//=============================================================================
// WeaponDagger.
//=============================================================================
class WeaponDagger extends DeusExWeapon;

simulated function PreBeginPlay()
{
	Super.PreBeginPlay();

	// If this is a netgame, then override defaults
	if ( Level.NetMode != NM_StandAlone )
	{
		HitDamage = mpHitDamage;
		BaseAccuracy = mpBaseAccuracy;
		ReloadTime = mpReloadTime;
		AccurateRange = mpAccurateRange;
		MaxRange = mpMaxRange;
	}
}

defaultproperties
{
     LowAmmoWaterMark=0
     GoverningSkill=Class'DeusEx.SkillWeaponLowTech'
     NoiseLevel=0.050000
     EnemyEffective=ENMEFF_Organic
     Concealability=CONC_Visual
     reloadTime=0.000000
     maxRange=80
     AccurateRange=80
     BaseAccuracy=1.000000
     bHasMuzzleFlash=False
     bHandToHand=True
     bFallbackWeapon=True
     mpHitDamage=25
     mpBaseAccuracy=1.000000
     mpAccurateRange=96
     mpMaxRange=96
     AmmoName=Class'DeusEx.AmmoNone'
     ReloadCount=0
     bInstantHit=True
     FireOffset=(X=-5.000000,Y=8.000000,Z=14.000000)
     shakemag=20.000000
     FireSound=Sound'DeusExSounds.Weapons.CombatKnifeFire'
     SelectSound=Sound'MarkistanGuns.Weapons.DaggerSelect'
     Misc1Sound=Sound'DeusExSounds.Weapons.CombatKnifeHitFlesh'
     Misc2Sound=Sound'MarkistanGuns.Weapons.DaggerHitHard'
     Misc3Sound=Sound'MarkistanGuns.Weapons.DaggerHitSoft'
     InventoryGroup=194
     ItemName="Dagger"
     PlayerViewOffset=(X=5.000000,Y=-8.000000,Z=-14.000000)
     PlayerViewMesh=LodMesh'DeusExItems.CombatKnife'
     PlayerViewScale=1.500000
     PickupViewMesh=LodMesh'DeusExItems.CombatKnifePickup'
     PickupViewScale=1.500000
     ThirdPersonMesh=LodMesh'DeusExItems.CombatKnife3rd'
     ThirdPersonScale=1.500000
     Icon=Texture'DeusExUI.Icons.BeltIconCombatKnife'
     largeIcon=Texture'DeusExUI.Icons.LargeIconCombatKnife'
     largeIconWidth=49
     largeIconHeight=45
     invSlotsX=2
     Description="An old-fashioned medieval dagger, extremely deadly."
     beltDescription="DAGGER"
     Mesh=LodMesh'DeusExItems.CombatKnifePickup'
     DrawScale=1.500000
     CollisionRadius=18.975000
     CollisionHeight=1.200000
}
